/*******************************************************************************
  MPLAB Harmony Graphics Object Library Asset Source File

  File Name:
    gfx_assets.c

  Summary:
    Source file containing asset data for use with the MPLAB Harmony Graphics
	Object Library.

  Description:
    Source file containing asset data for use with the MPLAB Harmony Graphics
	Object Library.

    Created with MPLAB Harmony Version 2.04
*******************************************************************************/
// DOM-IGNORE-BEGIN
/*******************************************************************************
Copyright (c) 2013-2014 released Microchip Technology Inc.  All rights reserved.

Microchip licenses to you the right to use, modify, copy and distribute
Software only when embedded on a Microchip microcontroller or digital signal
controller that is integrated into your product or third party product
(pursuant to the sublicense terms in the accompanying license agreement).

You should refer to the license agreement accompanying this Software for
additional information regarding your rights and obligations.

SOFTWARE AND DOCUMENTATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
(INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
*******************************************************************************/
// DOM-IGNORE-END

#include "gfx/gfx_assets.h"

/*****************************************************************************
 Asset Manifest
 -------------------
 
 Fonts
 -------
    MS_gothic_28


 String Table
 -------
    stringTable
 
 *****************************************************************************/

/*****************************************************************************
 * SECTION:  Fonts
 
 - font lookup table data description -
1 byte - size of the address offset values in this table, 1-4 possible
1 byte - size of the address width values in this table, 1-2 possible
  for each glyph entry in lookup table:
    1-4 bytes - glyph data offset in bytes
    1-2 bytes - glyph raster width in pixels	
 
 *****************************************************************************/
uint8_t MS_gothic_28_lookup_20_7F[290] =
{
    0x02,0x01,0x00,0x00,0x10,0x3A,0x00,0x10,0x74,0x00,0x10,0xAE,0x00,0x10,0xE8,
    0x00,0x10,0x22,0x01,0x10,0x5C,0x01,0x10,0x96,0x01,0x10,0xD0,0x01,0x10,0x0A,
    0x02,0x10,0x44,0x02,0x10,0x7E,0x02,0x10,0xB8,0x02,0x10,0xF2,0x02,0x10,0x2C,
    0x03,0x10,0x66,0x03,0x10,0xA0,0x03,0x10,0xDA,0x03,0x10,0x14,0x04,0x10,0x4E,
    0x04,0x10,0x88,0x04,0x10,0xC2,0x04,0x10,0xFC,0x04,0x10,0x36,0x05,0x10,0x70,
    0x05,0x10,0xAA,0x05,0x10,0xE4,0x05,0x10,0x1E,0x06,0x10,0x58,0x06,0x10,0x92,
    0x06,0x10,0xCC,0x06,0x10,0x06,0x07,0x10,0x40,0x07,0x10,0x7A,0x07,0x10,0xB4,
    0x07,0x10,0xEE,0x07,0x10,0x28,0x08,0x10,0x62,0x08,0x10,0x9C,0x08,0x10,0xD6,
    0x08,0x10,0x10,0x09,0x10,0x4A,0x09,0x10,0x84,0x09,0x10,0xBE,0x09,0x10,0xF8,
    0x09,0x10,0x32,0x0A,0x10,0x6C,0x0A,0x10,0xA6,0x0A,0x10,0xE0,0x0A,0x10,0x1A,
    0x0B,0x10,0x54,0x0B,0x10,0x8E,0x0B,0x10,0xC8,0x0B,0x10,0x02,0x0C,0x10,0x3C,
    0x0C,0x10,0x76,0x0C,0x10,0xB0,0x0C,0x10,0xEA,0x0C,0x10,0x24,0x0D,0x10,0x5E,
    0x0D,0x10,0x98,0x0D,0x10,0xD2,0x0D,0x10,0x0C,0x0E,0x10,0x46,0x0E,0x10,0x80,
    0x0E,0x10,0xBA,0x0E,0x10,0xF4,0x0E,0x10,0x2E,0x0F,0x10,0x68,0x0F,0x10,0xA2,
    0x0F,0x10,0xDC,0x0F,0x10,0x16,0x10,0x10,0x50,0x10,0x10,0x8A,0x10,0x10,0xC4,
    0x10,0x10,0xFE,0x10,0x10,0x38,0x11,0x10,0x72,0x11,0x10,0xAC,0x11,0x10,0xE6,
    0x11,0x10,0x20,0x12,0x10,0x5A,0x12,0x10,0x94,0x12,0x10,0xCE,0x12,0x10,0x08,
    0x13,0x10,0x42,0x13,0x10,0x7C,0x13,0x10,0xB6,0x13,0x10,0xF0,0x13,0x10,0x2A,
    0x14,0x10,0x64,0x14,0x10,0x9E,0x14,0x10,0xD8,0x14,0x10,0x12,0x15,0x10,0x4C,
    0x15,0x10,0x86,0x15,0x1E,
};


GFXU_FontGlyphIndexTable MS_gothic_28_index_table =
{
	1, // range count
    {
	    /* 0x20-0x7F */
        {
		    96, // glyph count
		    0x20, // starting glyph id
		    0x7F, // ending glyph id
		    MS_gothic_28_lookup_20_7F // glyph lookup table
        },
    }
};
		
// 96 glyphs @ 1 bpp
const uint8_t MS_gothic_28_data[5626] =
{
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,
    0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x07,0xBC,0x07,0x3C,0x0F,0x78,0x0E,0x70,0x1C,0xF0,0x1C,0xE0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x03,0x1C,0x07,0x1C,0x07,0x18,0x07,0x18,0x07,0x18,0x07,0x38,0x3F,0xFE,0x3F,
    0xFE,0x06,0x38,0x06,0x38,0x06,0x38,0x0E,0x30,0x0E,0x30,0x0E,0x30,0x0E,0x30,
    0x3F,0xFE,0x3F,0xFE,0x0C,0x70,0x0C,0x70,0x0C,0x70,0x0C,0x70,0x1C,0x60,0x1C,
    0x60,0x1C,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x01,0xC0,
    0x07,0xF0,0x0F,0xF8,0x0F,0xB8,0x1D,0xBC,0x1D,0xBC,0x1D,0xBC,0x1D,0x80,0x0F,
    0x80,0x0F,0x80,0x07,0xC0,0x03,0xF0,0x01,0xF8,0x01,0xF8,0x01,0xFC,0x1D,0xDC,
    0x1D,0xDC,0x1D,0xDC,0x1D,0xFC,0x1F,0xF8,0x0F,0xF8,0x07,0xE0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x18,0x1E,0x18,
    0x37,0x30,0x33,0x30,0x33,0x30,0x33,0x20,0x33,0x60,0x33,0x60,0x33,0x40,0x33,
    0xC0,0x3F,0xC0,0x1E,0xF8,0x01,0xFC,0x01,0xEE,0x01,0xEE,0x03,0x66,0x03,0x66,
    0x03,0x66,0x06,0x66,0x06,0x66,0x06,0x6E,0x0C,0x7E,0x0C,0x3C,0x0C,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x07,0xE0,0x0F,0xF0,
    0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0xE0,0x0F,0xE0,0x07,0xC0,0x0F,
    0x80,0x1F,0x80,0x1F,0xDE,0x3D,0xDC,0x39,0xFC,0x38,0xFC,0x38,0x7C,0x38,0x7C,
    0x38,0x3C,0x1C,0x7E,0x1F,0xFE,0x0F,0xE6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x0C,0x00,
    0x0C,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x04,0x00,0x0E,0x00,0x1C,0x00,0x38,0x00,0x38,0x00,0x70,
    0x00,0x60,0x00,0xE0,0x00,0xE0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x01,0xC0,0x01,
    0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xE0,0x00,0xE0,0x00,0x70,0x00,0x70,
    0x00,0x38,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x04,0x00,0x00,0x00,0x00,0x00,
    0x00,0x10,0x00,0x38,0x00,0x1C,0x00,0x0C,0x00,0x0E,0x00,0x07,0x00,0x07,0x00,
    0x03,0x80,0x03,0x80,0x03,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,
    0x80,0x01,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x07,0x00,0x07,0x00,0x0E,0x00,
    0x1C,0x00,0x1C,0x00,0x38,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x01,0xC0,
    0x11,0xC4,0x39,0xCE,0x3F,0xFE,0x1F,0xFC,0x07,0xF0,0x07,0xF0,0x1F,0xFC,0x3F,
    0xFE,0x39,0xCE,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x01,0xC0,
    0x01,0xC0,0x01,0xC0,0x01,0xC0,0x3F,0xFE,0x3F,0xFE,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x0E,0x00,0x0C,0x00,
    0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x3F,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,
    0x18,0x00,0x38,0x00,0x30,0x00,0x70,0x00,0x60,0x00,0xE0,0x00,0xC0,0x01,0xC0,
    0x01,0x80,0x01,0x80,0x03,0x00,0x03,0x00,0x07,0x00,0x06,0x00,0x0E,0x00,0x0C,
    0x00,0x1C,0x00,0x18,0x00,0x38,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x80,0x07,0xF0,0x0F,0xF8,0x1E,0x38,0x1E,0x3C,0x1C,
    0x1C,0x3C,0x1C,0x3C,0x1E,0x3C,0x1E,0x38,0x1E,0x38,0x1E,0x38,0x1E,0x38,0x1E,
    0x38,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1C,0x1C,0x3C,0x1E,0x3C,0x0F,0x78,0x07,
    0xF0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0xE0,0x00,0xE0,0x01,0xE0,0x0F,0xE0,0x0F,0xE0,0x01,0xE0,0x01,
    0xE0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x01,0xE0,
    0x01,0xE0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x01,0xE0,0x01,
    0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x80,0x07,0xF0,0x0F,0xF8,0x1E,0x3C,0x1E,0x3C,0x1C,0x1C,0x1C,0x1C,0x00,
    0x3C,0x00,0x3C,0x00,0x38,0x00,0x78,0x00,0xF0,0x01,0xE0,0x01,0xE0,0x03,0xC0,
    0x07,0x80,0x0F,0x00,0x0E,0x00,0x1E,0x00,0x1C,0x00,0x3F,0xFC,0x3F,0xFC,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,
    0x07,0xF0,0x0F,0xF8,0x1E,0x3C,0x1C,0x3C,0x1C,0x3C,0x00,0x1C,0x00,0x3C,0x00,
    0x38,0x00,0x78,0x01,0xE0,0x01,0xF0,0x00,0x38,0x00,0x3C,0x00,0x1C,0x3C,0x1C,
    0x3C,0x1C,0x3C,0x1C,0x1C,0x3C,0x1E,0x78,0x0F,0xF0,0x03,0xC0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x78,
    0x00,0xF8,0x00,0xF8,0x01,0xF8,0x01,0xF8,0x03,0xF8,0x03,0xF8,0x07,0x78,0x07,
    0x78,0x0E,0x78,0x0E,0x78,0x1C,0x78,0x3C,0x78,0x38,0x78,0x3F,0xFE,0x3F,0xFE,
    0x00,0x78,0x00,0x78,0x00,0x78,0x00,0x78,0x00,0x78,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFC,0x0F,0xFC,0x0E,0x00,
    0x0E,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1F,0xF0,0x1F,0xF8,0x1E,
    0x3C,0x1C,0x3C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x3C,0x1C,0x3C,0x3C,
    0x1C,0x3C,0x1E,0x78,0x0F,0xF0,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xF8,0x07,0xF8,0x0F,0x3C,
    0x0E,0x1C,0x1E,0x00,0x1C,0x00,0x1C,0x00,0x1F,0xE0,0x1F,0xF8,0x1F,0x3C,0x1E,
    0x3C,0x1E,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1E,0x1C,0x0E,0x3C,
    0x0F,0x78,0x07,0xF8,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x1F,0xFC,0x1F,0xFC,0x00,0x1C,0x00,0x1C,0x00,0x3C,
    0x00,0x38,0x00,0x38,0x00,0x78,0x00,0x78,0x00,0x70,0x00,0x70,0x00,0xF0,0x00,
    0xE0,0x00,0xE0,0x01,0xE0,0x01,0xE0,0x01,0xC0,0x01,0xC0,0x03,0xC0,0x03,0xC0,
    0x03,0x80,0x03,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x01,0x80,0x07,0xF0,0x0F,0x78,0x1E,0x38,0x1C,0x3C,0x1C,0x1C,
    0x1C,0x1C,0x1C,0x1C,0x1E,0x3C,0x0E,0x78,0x07,0xF0,0x0F,0xF0,0x1E,0x38,0x1C,
    0x1C,0x3C,0x1C,0x3C,0x1E,0x3C,0x1E,0x3C,0x1C,0x1C,0x3C,0x1E,0x7C,0x0F,0xF8,
    0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x80,0x07,0xF0,0x0F,0xF0,0x1E,0x38,0x1C,0x38,0x1C,0x3C,0x3C,0x1C,
    0x3C,0x1C,0x3C,0x1C,0x1C,0x3C,0x1C,0x3C,0x1E,0x3C,0x0E,0x7C,0x0F,0xFC,0x03,
    0xDC,0x00,0x3C,0x00,0x3C,0x1C,0x38,0x1E,0x78,0x1E,0xF0,0x0F,0xE0,0x03,0x80,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x0E,0x00,
    0x1C,0x00,0x38,0x00,0x70,0x00,0xE0,0x01,0xC0,0x03,0x80,0x07,0x00,0x0E,0x00,
    0x1C,0x00,0x3C,0x00,0x1E,0x00,0x0F,0x00,0x07,0x80,0x03,0xC0,0x01,0xE0,0x00,
    0xF0,0x00,0x78,0x00,0x3C,0x00,0x1E,0x00,0x0E,0x00,0x04,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,0x3F,0xFE,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,
    0x00,0x03,0x80,0x01,0xC0,0x00,0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x1E,
    0x00,0x3C,0x00,0x78,0x00,0xF0,0x01,0xE0,0x03,0xC0,0x07,0x80,0x0F,0x00,0x1E,
    0x00,0x3C,0x00,0x38,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x03,0xC0,0x0F,0xF0,0x0F,0x78,0x1E,0x3C,0x1C,0x3C,0x1C,
    0x3C,0x1C,0x3C,0x1C,0x3C,0x00,0x3C,0x00,0x38,0x00,0x78,0x00,0xF0,0x01,0xE0,
    0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
    0xC0,0x03,0xC0,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x03,0xF0,0x07,0x38,0x0E,0x1C,0x0C,0x0C,0x18,0x0E,0x19,0xFE,0x3B,
    0xFE,0x37,0x76,0x36,0x36,0x36,0x76,0x3E,0x76,0x3E,0x76,0x3E,0x76,0x3E,0x76,
    0x3E,0x66,0x3E,0x6E,0x37,0xEC,0x37,0xF8,0x38,0x00,0x18,0x00,0x1C,0x00,0x0C,
    0x18,0x07,0x70,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0xC0,0x01,0xC0,0x03,0xE0,0x03,0xE0,0x03,0xE0,0x03,0xE0,0x07,0xF0,0x07,
    0xF0,0x07,0x70,0x07,0x70,0x0F,0x78,0x0E,0x78,0x0E,0x38,0x0F,0xF8,0x1F,0xFC,
    0x1E,0x3C,0x1C,0x1C,0x1C,0x1C,0x3C,0x1E,0x3C,0x1E,0x38,0x0E,0x78,0x0F,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x80,
    0x3F,0xF8,0x3C,0x78,0x3C,0x3C,0x3C,0x1C,0x3C,0x1C,0x3C,0x1C,0x3C,0x1C,0x3C,
    0x3C,0x3F,0xF8,0x3F,0xF0,0x3C,0x78,0x3C,0x1C,0x3C,0x1E,0x3C,0x0E,0x3C,0x0E,
    0x3C,0x0E,0x3C,0x1E,0x3C,0x3C,0x3C,0x7C,0x3F,0xF8,0x3F,0xC0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x03,0xF8,
    0x07,0xFC,0x0F,0x1C,0x1E,0x1E,0x1C,0x1E,0x1C,0x0E,0x3C,0x0E,0x3C,0x00,0x3C,
    0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x1E,0x3C,0x1E,0x1C,0x1E,
    0x1E,0x1C,0x0E,0x3C,0x0F,0xFC,0x07,0xF8,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x3F,0xE0,0x3D,0xF0,
    0x3C,0x78,0x3C,0x3C,0x3C,0x3C,0x3C,0x1C,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,
    0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x3C,0x3C,0x3C,
    0x3C,0x78,0x3D,0xF8,0x3F,0xE0,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFC,0x3F,0xFC,0x3C,0x00,0x3C,0x00,
    0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3F,0xFC,0x3F,0xFC,0x3C,
    0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,
    0x3C,0x00,0x3F,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,0x3F,0xFE,0x3C,0x00,0x3C,0x00,0x3C,0x00,
    0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3F,0xF8,0x3F,0xF8,0x3C,
    0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,
    0x3C,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0xC0,0x03,0xF8,0x0F,0xF8,0x0F,0x3C,0x1E,0x1C,0x1E,0x1C,
    0x1C,0x1E,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0xFE,0x3C,0xFE,0x3C,0x0E,0x3C,
    0x0E,0x3C,0x0E,0x3C,0x0E,0x1C,0x1E,0x1E,0x1E,0x1E,0x3E,0x0F,0x7E,0x07,0xFE,
    0x01,0xCE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,
    0x3C,0x1E,0x3C,0x1E,0x3F,0xFE,0x3F,0xFE,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,
    0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,
    0xE0,0x07,0xE0,0x07,0xE0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,
    0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,
    0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x07,0xE0,0x07,0xE0,0x07,0xE0,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,
    0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,
    0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
    0x3C,0x3C,0x3C,0x1E,0x3C,0x1F,0xF8,0x0F,0xF0,0x01,0xC0,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x1E,0x3C,0x3C,0x3C,
    0x3C,0x3C,0x78,0x3C,0xF0,0x3C,0xF0,0x3D,0xE0,0x3F,0xC0,0x3F,0x80,0x3F,0xC0,
    0x3F,0xC0,0x3F,0xC0,0x3D,0xE0,0x3C,0xE0,0x3C,0xF0,0x3C,0x70,0x3C,0x78,0x3C,
    0x38,0x3C,0x3C,0x3C,0x1C,0x3C,0x1E,0x3C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,
    0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,
    0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,
    0x00,0x3C,0x00,0x3F,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
    0x3E,0x3E,0x3E,0x3F,0x3E,0x3F,0x3E,0x3F,0x3E,0x3F,0x6E,0x3F,0x6E,0x3F,0x6E,
    0x3B,0xEE,0x3B,0xEE,0x3B,0xEE,0x3B,0xEE,0x3B,0xEE,0x3B,0xCE,0x39,0xCE,0x39,
    0xCE,0x39,0xCE,0x39,0xCE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x3C,0x1E,0x3E,0x1E,0x3E,0x1E,0x3E,0x1E,0x3F,0x1E,0x3F,
    0x1E,0x3F,0x1E,0x3F,0x9E,0x3B,0x9E,0x3B,0x9E,0x39,0xDE,0x39,0xDE,0x39,0xFE,
    0x38,0xFE,0x38,0xFE,0x38,0xFE,0x38,0x7E,0x38,0x7E,0x38,0x7E,0x38,0x3E,0x38,
    0x3E,0x38,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0x80,0x07,0xF0,0x0F,0xF8,0x1E,0x3C,0x1C,0x1C,0x3C,0x1C,0x3C,
    0x1E,0x3C,0x1E,0x38,0x1E,0x38,0x1E,0x38,0x1E,0x38,0x1E,0x38,0x1E,0x38,0x1E,
    0x3C,0x1E,0x3C,0x1E,0x3C,0x1C,0x1C,0x1C,0x1E,0x3C,0x0F,0x78,0x0F,0xF0,0x03,
    0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x3F,0x80,0x3F,0xF8,0x3C,0xFC,0x3C,0x3C,0x3C,0x1E,0x3C,0x0E,0x3C,0x0E,0x3C,
    0x0E,0x3C,0x1E,0x3C,0x1C,0x3C,0x7C,0x3F,0xF8,0x3F,0xC0,0x3C,0x00,0x3C,0x00,
    0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,
    0x07,0xF0,0x0F,0xF8,0x1E,0x3C,0x1C,0x1C,0x3C,0x1C,0x3C,0x1E,0x3C,0x1E,0x38,
    0x1E,0x38,0x1E,0x38,0x1E,0x38,0x1E,0x38,0x1E,0x38,0x1E,0x3C,0x7E,0x3C,0xFE,
    0x3C,0xFE,0x1C,0x7C,0x1E,0x7C,0x0F,0x78,0x0F,0xFC,0x03,0xFC,0x00,0x18,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x80,0x3F,0xF0,
    0x3C,0xFC,0x3C,0x3C,0x3C,0x1C,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1C,0x3C,
    0x7C,0x3F,0xF8,0x3F,0xF0,0x3C,0xF0,0x3C,0x70,0x3C,0x70,0x3C,0x78,0x3C,0x38,
    0x3C,0x3C,0x3C,0x3C,0x3C,0x1C,0x3C,0x1E,0x3C,0x0E,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x07,0xF0,0x0F,0xF8,
    0x1E,0x3C,0x1C,0x1C,0x1C,0x1C,0x1C,0x00,0x1E,0x00,0x1F,0x00,0x0F,0x80,0x07,
    0xC0,0x01,0xF0,0x00,0xF8,0x00,0x3C,0x00,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,
    0x1C,0x3C,0x1E,0x7C,0x0F,0xF8,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,0x3F,0xFE,0x03,0xC0,0x03,0xC0,
    0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,
    0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,
    0x03,0xC0,0x03,0xC0,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,
    0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,
    0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1C,0x3E,0x3C,0x1F,0xFC,
    0x0F,0xF8,0x03,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x38,0x0E,0x38,0x0E,0x3C,0x1E,0x3C,0x1C,0x1C,0x1C,0x1C,0x1C,
    0x1C,0x1C,0x1E,0x3C,0x1E,0x38,0x0E,0x38,0x0E,0x38,0x0F,0x38,0x0F,0x30,0x07,
    0x70,0x07,0x70,0x07,0xF0,0x07,0xE0,0x03,0xE0,0x03,0xE0,0x03,0xE0,0x03,0xC0,
    0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x71,0xCF,0x79,0xCE,0x79,0xCE,0x3B,0xCE,0x3B,0xEE,0x3B,0xEE,0x3B,0xEE,
    0x3B,0xEE,0x3B,0xEE,0x3B,0xEE,0x3B,0x6C,0x3F,0x6C,0x1E,0x7C,0x1E,0x7C,0x1E,
    0x7C,0x1E,0x7C,0x1E,0x7C,0x1E,0x7C,0x1E,0x3C,0x1E,0x38,0x1E,0x38,0x0E,0x38,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,
    0x1E,0x1C,0x1C,0x1C,0x3C,0x1E,0x38,0x0E,0x78,0x0F,0x78,0x07,0x70,0x07,0xF0,
    0x03,0xE0,0x03,0xE0,0x03,0xC0,0x03,0xE0,0x03,0xE0,0x07,0xF0,0x07,0x70,0x0F,
    0x70,0x0E,0x78,0x1E,0x38,0x1C,0x3C,0x1C,0x1C,0x3C,0x1E,0x38,0x0E,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x0E,0x3C,
    0x1E,0x3C,0x1C,0x1C,0x1C,0x1E,0x3C,0x0E,0x38,0x0F,0x38,0x0F,0x70,0x07,0xF0,
    0x07,0xE0,0x03,0xE0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,
    0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x03,0xC0,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFC,0x1F,0xFC,0x00,
    0x1C,0x00,0x3C,0x00,0x38,0x00,0x78,0x00,0x70,0x00,0xF0,0x00,0xE0,0x01,0xE0,
    0x01,0xC0,0x03,0xC0,0x03,0x80,0x07,0x80,0x07,0x00,0x0F,0x00,0x0E,0x00,0x1E,
    0x00,0x1C,0x00,0x3C,0x00,0x3F,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFC,0x03,0xFC,0x03,0x80,0x03,
    0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,
    0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,
    0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0xFC,0x03,0xFC,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x0F,0x38,0x1E,0x3C,0x1E,0x1C,0x1C,0x1E,
    0x3C,0x0E,0x38,0x0E,0x78,0x0F,0x70,0x07,0x70,0x07,0xE0,0x03,0xE0,0x3F,0xFE,
    0x3F,0xFE,0x01,0xC0,0x3F,0xFE,0x3F,0xFE,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x3F,0xC0,0x3F,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,
    0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x01,0xC0,0x3F,0xC0,0x3F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
    0x03,0xE0,0x07,0xF0,0x0F,0x78,0x1C,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x80,0x03,0xC0,0x03,0xC0,
    0x01,0xE0,0x00,0xE0,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xF0,0x0F,0xF8,0x1E,
    0x3C,0x1E,0x1C,0x1C,0x3C,0x00,0x7C,0x03,0xFC,0x0F,0xDC,0x1E,0x1C,0x1C,0x1C,
    0x3C,0x1C,0x3C,0x3C,0x1E,0x7C,0x1F,0xFC,0x07,0x9E,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,
    0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1F,0xF0,0x1F,0xF8,0x1E,0x3C,0x1C,
    0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
    0x1C,0x3C,0x1E,0x78,0x1F,0xF0,0x1D,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xF0,0x0F,0xF8,0x0E,0x3C,0x1C,0x1C,0x1C,
    0x1C,0x3C,0x00,0x3C,0x00,0x3C,0x00,0x3C,0x1E,0x3C,0x1E,0x1C,0x1C,0x1E,0x3C,
    0x0F,0x7C,0x07,0xF8,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,
    0x00,0x1C,0x00,0x1C,0x07,0xFC,0x0F,0xFC,0x1E,0x3C,0x1C,0x3C,0x3C,0x1C,0x3C,
    0x1C,0x3C,0x1C,0x3C,0x1C,0x3C,0x1C,0x3C,0x1C,0x3C,0x3C,0x1C,0x3C,0x1E,0x7C,
    0x0F,0xFC,0x03,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x03,0xF0,0x0F,0xF8,0x1E,0x3C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x3F,
    0xFC,0x3F,0xFC,0x3C,0x00,0x1C,0x00,0x1C,0x1C,0x1E,0x1C,0x0F,0x7C,0x07,0xF8,
    0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x70,0x01,0xFE,0x03,0xFE,0x03,0x82,0x03,0x80,0x03,0x80,0x03,0x80,
    0x3F,0xFC,0x3F,0xFC,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,
    0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFE,
    0x0F,0xFE,0x0E,0x78,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1E,0x78,0x0F,0xF0,0x0F,
    0xE0,0x1C,0x00,0x1C,0x00,0x1F,0x00,0x0F,0xFC,0x1C,0x3C,0x38,0x0E,0x38,0x0E,
    0x1C,0x1C,0x1F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,
    0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1D,0xF8,0x1F,0xFC,
    0x1F,0x1C,0x1E,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
    0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x01,0xC0,0x01,0xC0,
    0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,
    0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,
    0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x1F,0xF0,0x1F,0xE0,0x07,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,
    0x00,0x1C,0x00,0x1C,0x00,0x1C,0x3C,0x1C,0x78,0x1C,0xF0,0x1D,0xE0,0x1D,0xC0,
    0x1F,0xC0,0x1F,0xE0,0x1F,0xE0,0x1E,0xF0,0x1C,0x70,0x1C,0x78,0x1C,0x38,0x1C,
    0x3C,0x1C,0x1C,0x1C,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,
    0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x3F,0xFE,0x3F,0xFE,0x39,0xEE,0x39,0xCE,0x39,0xCE,0x39,0xCE,0x39,0xCE,
    0x39,0xCE,0x39,0xCE,0x39,0xCE,0x39,0xCE,0x39,0xCE,0x39,0xCE,0x39,0xCE,0x39,
    0xCE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1D,
    0xF8,0x1F,0xFC,0x1F,0x1C,0x1E,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
    0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xF0,0x0F,
    0xF8,0x1E,0x3C,0x1C,0x1C,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,0x3C,0x1E,
    0x3C,0x1E,0x3C,0x1C,0x1C,0x3C,0x1E,0x78,0x0F,0xF0,0x01,0xC0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF0,0x1F,0xF8,0x1E,
    0x3C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1E,0x1C,0x1E,0x1C,0x1E,0x1C,0x1E,0x1C,0x1E,
    0x1C,0x1C,0x1E,0x3C,0x1F,0x78,0x1F,0xF0,0x1F,0xC0,0x1C,0x00,0x1C,0x00,0x1C,
    0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFC,0x0F,0xFC,0x1E,0x3C,0x1C,
    0x3C,0x3C,0x1C,0x3C,0x1C,0x38,0x1C,0x38,0x1C,0x38,0x1C,0x3C,0x1C,0x3C,0x3C,
    0x1C,0x3C,0x1E,0x7C,0x0F,0xFC,0x03,0xDC,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,
    0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0xF8,0x0F,0xF8,0x0F,0xF8,0x0F,0x80,0x0F,
    0x00,0x0F,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,
    0x0E,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x07,0xF0,0x0F,0xF8,0x1E,0x38,0x1C,0x3C,0x1E,0x00,0x0F,
    0x00,0x07,0xC0,0x01,0xF0,0x00,0x78,0x1C,0x3C,0x1C,0x1C,0x1C,0x1C,0x1E,0x7C,
    0x0F,0xF8,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,
    0x03,0x80,0x3F,0xFC,0x3F,0xFC,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,
    0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x9C,0x03,0xFC,
    0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
    0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x3C,0x1C,0x7C,0x1F,0xFC,0x07,0x9C,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x1C,
    0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0F,0x30,0x07,
    0x70,0x07,0x70,0x07,0xE0,0x03,0xE0,0x03,0xE0,0x03,0xC0,0x01,0xC0,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xCE,0x39,0xCE,
    0x3B,0xEE,0x3B,0xEE,0x3B,0xEE,0x3F,0xEC,0x3F,0xEC,0x1F,0xEC,0x1F,0x6C,0x1F,
    0x7C,0x1E,0x7C,0x1E,0x78,0x0E,0x78,0x0E,0x78,0x0E,0x38,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x3C,0x1E,0x38,0x0E,0x78,
    0x07,0x70,0x07,0xF0,0x03,0xE0,0x03,0xE0,0x03,0xC0,0x03,0xE0,0x07,0xF0,0x07,
    0x70,0x0F,0x78,0x1E,0x38,0x1C,0x3C,0x3C,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x1E,0x1C,0x1C,0x1C,0x1C,0x1E,0x1C,
    0x0E,0x38,0x0E,0x38,0x0F,0x38,0x07,0x30,0x07,0xF0,0x03,0xF0,0x03,0xE0,0x03,
    0xE0,0x01,0xE0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x1F,0x80,0x1F,0x80,0x0C,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x1F,0xF8,0x1F,0xF8,0x00,0x38,0x00,0x70,0x00,0xF0,
    0x00,0xE0,0x01,0xC0,0x03,0xC0,0x03,0x80,0x07,0x00,0x0F,0x00,0x1E,0x00,0x1C,
    0x00,0x3F,0xFC,0x3F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x7C,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,
    0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x01,0xE0,0x01,0xE0,
    0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,
    0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x3C,0x00,0x00,0x00,0x00,0x01,0xC0,
    0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,
    0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,
    0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x00,0x00,0x00,0x00,0x1E,0x00,
    0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,
    0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x03,0xC0,0x03,0xC0,0x07,0x00,0x07,0x00,
    0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,0x00,0x07,
    0x00,0x07,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x06,0x04,0x0F,0x8C,0x1F,0xCC,
    0x19,0xFC,0x18,0x78,0x08,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xE0,0x07,
    0xFF,0xFF,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,
    0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,
    0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,
    0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,
    0x00,0x00,0xE0,0x07,0x00,0x00,0xE0,0x07,0xFF,0xFF,0xE0,0x07,0xFF,0xFF,0xE0,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,
};

GFXU_FontAsset MS_gothic_28 =
{
	{
        GFXU_ASSET_TYPE_FONT, // asset type
	    GFXU_ASSET_LOCATION_ID_INTERNAL, // data location id
	    (void*)MS_gothic_28_data, // data address pointer
	    5626, // data size
    },	
	29, // font height
	25, // font max ascent
	4, // font max descent
	4, // font baseline
	GFXU_FONT_BPP_1, // bits per pixel
	&MS_gothic_28_index_table // glyph index table
};
		


/*****************************************************************************
 * SECTION:  Strings
 
 - String table data format description -

 2 bytes - number of unique string values
 
 for each string value:
   2 bytes - size of the string in bytes
   n bytes - character code point data, 1-4 bytes each character per encoding	 
 *****************************************************************************/
// 2 languages, 2 unique string value, ASCII encoding
uint8_t stringTable_data[14] =
{
    0x02,0x00,0x08,0x00,0x6D,0x79,0x20,0x4C,0x61,0x62,0x65,0x6C,0x00,0x00,
};
	
/*****************************************************************************
  - String index table data format description -

 2 bytes - number of strings in the string table
 1 byte - number of languages in the string table
 1 byte - size of the string indicies, equals 2 if there are more than 254
          strings
		  
 for each string in table:
    for each language in table:
	    1-2 bytes - string data table entry	 
 *****************************************************************************/
// Lookup table for associating string and language IDs to string data.
uint8_t stringIndexTable_data[6] =
{
    0x01,0x00,0x02,0x01,0x00,0x01,
};
	
GFXU_FontAsset* fontList[1] =
{
	&MS_gothic_28,
};

/*****************************************************************************
  - Font index table data format description -

 2 bytes - number of strings in the string table
 1 byte - number of languages in the string table
		  
 for each string in table:
    for each language in table:
	    1 byte - the font to use for the string	 
		
 id = 0xFF if no font association
 *****************************************************************************/
// Lookup table for associating strings, languages, and fonts
uint8_t fontIndexTable_data[5] =
{
    0x01,0x00,0x02,0x00,0x00,
};
	
GFXU_StringTableAsset stringTable =
{
	{
        GFXU_ASSET_TYPE_STRINGTABLE, // asset type
	    GFXU_ASSET_LOCATION_ID_INTERNAL, // data location id
	    (void*)stringTable_data, // data address pointer
	    14, // data size
    },	
	2, // language count
	1, // string count
    stringIndexTable_data, // font lookup table
    fontList, // font lookup table
    fontIndexTable_data, // font index table
	GFXU_STRING_ENCODING_ASCII // encoding standard
};
		

